// Created by inigo quilez - iq/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;
Texture2D tex0 <string uiname="Texture";>;
SamplerState s0:IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
float distance=2;
};


float hash1( float n )
{
    return frac(sin(n)*43758.5453123);
}

float hash2( in float2 f ) 
{ 
    return frac(sin(f.x+131.1*f.y)*43758.5453123); 
}


static float PI = 3.1415926535897932384626433832795;
static float PHI = 1.6180339887498948482045868343656;

float3 forwardSF( float i, float n) 
{
    float phi = 2.0*PI*frac(i/PHI);
    float zi = 1.0 - (2.0*i+1.0)/n;
    float sinTheta = sqrt( 1.0 - zi*zi);
    return float3( cos(phi)*sinTheta, sin(phi)*sinTheta, zi);
}

static float sca = 0.5 + 0.15*sin(time-10.0);
float4 grow = float(1.0);

float3 mapP( float3 p )
{
    p.xyz += 1.000*sin(  2.0*p.yzx )*grow.x;
    p.xyz += 0.500*sin(  4.0*p.yzx )*grow.y;
    p.xyz += 0.250*sin(  8.0*p.yzx )*grow.z;
    p.xyz += 0.050*sin( 16.0*p.yzx )*grow.w;
    return p;
}

float map( float3 q )
{
    float3 p = mapP( q );
    float d = length( p ) - 1.5;
	return d * 0.05;
}

float intersect( in float3 ro, in float3 rd )
{
	const float maxd = 7.0;

	float precis = 0.001;
    float h = 1.0;
    float t = 1.0;
    for( int i=0; i<1256; i++ )
    {
        if( (h<precis) || (t>maxd) ) break;
	    h = map( ro+rd*t );
        t += h;
    }

    if( t>maxd ) t=-1.0;
	return t;
}

float3 calcNormal( in float3 pos )
{
    float3 eps = float3(0.005,0.0,0.0);
	return normalize( float3(
           map(pos+eps.xyy) - map(pos-eps.xyy),
           map(pos+eps.yxy) - map(pos-eps.yxy),
           map(pos+eps.yyx) - map(pos-eps.yyx) ) );
}

float calcAO( in float3 pos, in float3 nor, in float2 pix )
{
	float ao = 0.0;
    for( int i=0; i<64; i++ )
    {
        float3 ap = forwardSF( float(i), 64.0 );
		ap *= sign( dot(ap,nor) ) * hash1(float(i));
        ao += clamp( map( pos + nor*0.05 + ap*1.0 )*32.0, 0.0, 1.0 );
    }
	ao /= 64.0;
	
    return clamp( ao*ao, 0.0, 1.0 );
}

float calcAO2( in float3 pos, in float3 nor, in float2 pix )
{
	float ao = 0.0;
    for( int i=0; i<32; i++ )
    {
        float3 ap = forwardSF( float(i), 32.0 );
		ap *= sign( dot(ap,nor) ) * hash1(float(i));
        ao += clamp( map( pos + nor*0.05 + ap*0.2 )*100.0, 0.0, 1.0 );
    }
	ao /= 32.0;
	
    return clamp( ao, 0.0, 1.0 );
}

float4 texCube( Texture2D tex0, in float3 p, in float3 n, in float k )
{
	float4 x = tex0.Sample( s0, p.yz );
	float4 y = tex0.Sample( s0, p.zx );
	float4 z = tex0.Sample( s0, p.xy );
    float3 w = pow( abs(n), float(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 p = (0.5-In.TexCd.xy)*distance;
	p.x *=  R.x / R.y;
	float4 q = In.TexCd;
	//q.y=1-In.TexCd.y;

    float2 m = float(0.5);
	   
    float4 grow = smoothstep( 0.0, 1.0, (time-float4(0.0,1.0,2.0,3.0))/3.0);

    
    //-----------------------------------------------------
    // camera
    //-----------------------------------------------------
	
	float an = 1.1 + 0.05*(time-10.0) - 7.0*m.x;

	float3 ro = float3(4.5*sin(an),1.0,4.5*cos(an));
    float3 ta = float3(0.0,0.2,0.0);
    // camera matrix
    float3 ww = normalize( ta - ro );
    float3 uu = normalize( cross(ww,float3(0.0,1.0,0.0) ) );
    float3 vv = normalize( cross(uu,ww));
	// create view ray
	float3 rd = normalize( p.x*uu + p.y*vv + 1.5*ww );


    //-----------------------------------------------------
	// render
    //-----------------------------------------------------
    
	float3 col = float(0.07)*clamp(1.0-length(q-0.5),0.0,1.0);

	// raymarch
    float t = intersect(ro,rd);

    if( t>0.0 )
    {
        float3 pos = ro + t*rd;
        float3 nor = calcNormal(pos);
		float3 ref = reflect( rd, nor );
        float3 sor = nor;
        
        float3 q = mapP( pos );
        float occ = calcAO( pos, nor, In.TexCd ); occ = occ*occ;

        // materials
		col = float(0.04);
        float ar = clamp(1.0-0.7*length(q-pos),0.0,1.0);
        col = lerp( col, float3(2.1,2.0,1.2), ar);
        col  *= 0.3;          
        col *= lerp(float3(1.0,0.4,0.3), float3(0.8,1.0,1.3), occ);
        float occ2 = calcAO2( pos, nor, In.TexCd );
        
        
        col *= 1.0*lerp( float3(2.0,0.4,0.2), float(1.0), occ2*occ2*occ2 );
        float ks = texCube( tex0, pos*1.5, nor, 4.0 ).x;
        ks = 0.5 + 1.0*ks;
        ks *= (1.0-ar);
        
        // lighting
        float sky = 0.5 + 0.5*nor.y;
        float fre = clamp( 1.0 + dot(nor,rd), 0.0, 1.0 );
        float spe = pow(max( dot(-rd,nor),0.0),8.0);
		// lights
		float3 lin  = float(0.0);
		     lin += 3.0*float3(0.7,0.80,1.00)*sky*occ;
             lin += 1.0*fre*float3(1.2,0.70,0.60)*(0.1+0.9*occ);
        col += 0.3*ks*4.0*float3(0.7,0.8,1.00)*smoothstep(0.0,0.2,ref.y)*(0.05+0.95*pow(fre,5.0))*(0.5+0.5*nor.y)*occ;
        col += 4.0*ks*1.5*spe*occ*col.x;
        col += 2.0*ks*1.0*pow(spe,8.0)*occ*col.x;
        col = col * lin;

        // dust
        col = lerp( col, 0.2*fre*fre*fre+0.6*float3(0.6,0.55,0.5)*sky*(0.8+0.4*texCube( tex0, pos*8.0, nor, 4.0 ).xyz), 0.6*smoothstep(0.3,0.7,nor.y)*sqrt(occ) );
        
        col *= 2.6*exp(-0.2*t);
    }

	col = pow(abs(col),float(0.4545));

    col = pow( col, float3(1.0,1.0,1.4) ) + float3(0.0,0.02,0.14);
    
    col += (1.0/255.0)*hash2( In.TexCd );
    
    return float4( col, 1.0 );

}


technique10 SculptureIII
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



